/**********************************************************
 
Fix figure numbers.js

Author: Dave Hirsch
Date: 11/9/2012
Version: 1.1

To Run This Script:  After you have adjusted the user-set parameters to match your file names, then select the script from within Illustrator, by choosing (at least on the Mac version): File > Scripts > Other Script and selecting this file.  It should just work at that point.

Notes: 
(1) The "%20" in the figNumPrefix is what AI-CS3 needs to indicate a space on my machine.  If %20 doesn't work, you should try a space, and vice-versa. This should be less of a problem (if at all) in version >= 1.1
(2) You can set debug to true if you want to see the progress.  Be warned, however, that if you run in debug mode on a large folder, you have to go through the whole folder like that (very slow), or force-quit Illustrator.
**********************************************************/

//  USER-SET PARAMETERS
var debug = false;
var figNumPrefix = "Fig "; //the number should come directly after this in the file names (be careful of spaces).
var figNumSuffix = "-"; // this is text that always follows the figure number in the file names (be careful of spaces).  It doesn't have to be the complete text that follows the number, though.
var captionFigNumPrefix = "Figure "; //the number should come directly after this in the caption text (be careful of spaces).
var captionFigNumSuffix = "."; // this is text that always follows the figure number in the caption text (be careful of spaces).  It doesn't have to be the complete text that follows the number, though.


/*********** YOU SHOULD NOT NEED TO MESS WITH ANYTHING BELOW THIS LINE! **************/

var inputFolder = Folder.selectDialog("FixFigureNumbers: Find the folder of files to process");
if (debug) alert ("inputFolder:" + inputFolder.fullName);
if (inputFolder) {
	var inputFolderNew = Folder(inputFolder.fullName);	// This should not be required, but CS5 chokes otherwise
	if (debug) alert ("inputFolderNew:" + inputFolderNew.fullName);
	if (inputFolderNew) {
		var files = inputFolderNew.getFiles("*.ai");
		if (debug) alert ("found this many files:" + files.length);
		var modifiedPrefix = figNumPrefix.replace("%20", " ");
		for ( i = 0; i < files.length; i++) {
			// check each document
			var fileNameStr = files[i].name;
			fileNameStr = fileNameStr.replace("%20", " ");
			if (fileNameStr.indexOf(figNumPrefix) == 0) {
				var curFile = files[i];
				if (debug) alert ("fileNameStr:" + fileNameStr);
				var prefixLength = modifiedPrefix.length;
				if (debug) alert ("prefixLength:" + prefixLength);
				var suffixPos = fileNameStr.indexOf(figNumSuffix);
				if (debug) alert ("suffixPos:" + suffixPos);
				var figNumLength = suffixPos - prefixLength;
				if (debug) alert ("figNumLength:" + figNumLength);
				var fileNumStr = fileNameStr.substr(prefixLength, figNumLength);
				if (debug) alert ("found figure number:" + fileNumStr);
				
				// these two lines should remove any leading zeros in the figure number needed to order the files correctly in the OS
				var fileNum = new Number(fileNumStr);
				var fileNumStr = fileNum.toString();
				delete fileNum;
				
				if (debug) alert ("adjusted figure number:" + fileNumStr);
				curDoc = app.open(curFile);
				
				// Find Figure Caption Text Frame
				var allTextFrames = curDoc.textFrames;
				for (j=0; j < allTextFrames.length; j++) {
					var curTextFrame = allTextFrames[j];
					var curStr = curTextFrame.contents;
					if (curStr.indexOf(captionFigNumPrefix) == 0) {
						// then this is the right one
						var captionTextFrame = curTextFrame;
					}
				}
				var captionText = captionTextFrame.contents;
				if (debug) alert ("found caption contents:" + captionText);
				
				var captionPrefixLength = captionFigNumPrefix.length;
				var captionFigNumLength = captionText.indexOf(captionFigNumSuffix) - captionPrefixLength;
				var captionFigNumStr = captionText.substr(captionPrefixLength, captionFigNumLength);
				if (debug) alert ("Figure num in caption:" + captionFigNumStr);
				captionText = captionText.replace(captionFigNumStr, fileNumStr);
				if (debug) alert ("New caption contents:" + captionText);
				captionTextFrame.contents = captionText;
				
				curDoc.save();
				curDoc.close();
			} else {
				if (debug) alert ("skipped this file:" + files[i].name);
			}
		}
	}
}
